//
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
//

#import <Foundation/Foundation.h>
#import <AmazonIVSBroadcast/IVSBase.h>

NS_ASSUME_NONNULL_BEGIN

/// A value representing which layer developer would like to receive as the first frame of video delivered to the stream.
typedef NS_ENUM(NSInteger, IVSSubscribeSimulcastConfigurationInitialLayerPreference) {
    /// The SFU will deliver the lowest bitrate layer of video first
    /// optimizing bandwidth consumption, as well as time to media.
    IVSSubscribeSimulcastConfigurationInitialLayerPreferenceLowestQuality = 0,
    /// The SFU will deliver the highest bitrate layer of video first
    /// which optimizes quality, but may increase the time to media.
    IVSSubscribeSimulcastConfigurationInitialLayerPreferenceHighestQuality,
} NS_SWIFT_NAME(IVSSubscribeSimulcastConfiguration.InitialLayerPreference);

/// A configuration object describing simulcast configuration.
IVS_EXPORT
@interface IVSSubscribeSimulcastConfiguration : NSObject

/// This specify which layer a developer would like to receive as the first frame of video delivered to the stream.
/// By default this is `IVSSubscribeSimulcastConfigurationInitialLayerPreferenceLowestQuality`.
@property (nonatomic) IVSSubscribeSimulcastConfigurationInitialLayerPreference initialLayerPreference;

@end

NS_ASSUME_NONNULL_END
