//
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
//

#import <Foundation/Foundation.h>
#import <AmazonIVSBroadcast/IVSBase.h>

NS_ASSUME_NONNULL_BEGIN

IVS_EXPORT
/// A remote stage stream layer
@interface IVSRemoteStageStreamLayer : NSObject

IVS_INIT_UNAVAILABLE

/// Generic string, derived from the publisher
@property (nonatomic, strong, readonly) NSString *label;
/// Bitrate in bits per second
@property (nonatomic, readonly) NSInteger bitrate;
/// Resolution in pixels
@property (nonatomic, readonly) CGSize size;
/// Framerate in frames per second
@property (nonatomic, readonly) NSInteger framesPerSecond;
/// Whether layer is selected
@property (nonatomic, readonly) BOOL selected;

@end

NS_ASSUME_NONNULL_END
