//
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
//

#import <Foundation/Foundation.h>
#import <AmazonIVSBroadcast/IVSBase.h>

NS_ASSUME_NONNULL_BEGIN

IVS_EXPORT
/// Constraints on remote stage stream layer.
@interface IVSRemoteStageStreamLayerConstraints : NSObject

/// The maximum bitrate.
@property (nonatomic) NSInteger maxBitrate;
/// The minimum bitrate.
@property (nonatomic) NSInteger minBitrate;
/// The maximum framerate.
@property (nonatomic) NSInteger maxFramerate;
/// The minimum framerate.
@property (nonatomic) NSInteger minFramerate;
/// The maximum width.
@property (nonatomic) NSInteger maxWidth;
/// The minimum bitrate.
@property (nonatomic) NSInteger minWidth;
/// The maximum height.
@property (nonatomic) NSInteger maxHeight;
/// The minimum height.
@property (nonatomic) NSInteger minHeight;

@end

NS_ASSUME_NONNULL_END