//
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
//

#import <Foundation/Foundation.h>
#import <AmazonIVSBroadcast/IVSBase.h>

NS_ASSUME_NONNULL_BEGIN

@class IVSJitterBufferConfiguration;
@class IVSSubscribeSimulcastConfiguration;

IVS_EXPORT
/// An object  that describes the configuration for subscribing.
@interface IVSSubscribeConfiguration : NSObject

/// This describes the jitter buffer configuration
@property (nonatomic, strong) IVSJitterBufferConfiguration *jitterBuffer;

/// This describes the simulcast configuration.
@property (nonatomic, strong) IVSSubscribeSimulcastConfiguration *simulcast;

/// The initial gain to set on any incoming audio streams. This can be used to mute streams
/// (by setting a gain of 0) before any audio samples have a chance to be played.
/// This value will be clamped between 0 and 2.
/// By default this value by will 1.0.
@property (nonatomic) float initialGain;

@end

NS_ASSUME_NONNULL_END
