//
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
//

#import <Foundation/Foundation.h>
#import <AmazonIVSBroadcast/IVSBase.h>

@class IVSLocalStageStreamLayer;

NS_ASSUME_NONNULL_BEGIN

/// Standard configurations for `IVSLocalStageStreamLayer` objects.
IVS_EXPORT
@interface IVSSimulcastLocalLayerPresets : NSObject

/// A preset appropriate for 160p layer.
- (IVSLocalStageStreamLayer *)default160;

/// A preset appropriate for 180p layer.
- (IVSLocalStageStreamLayer *)default180;

/// A preset appropriate for 270p layer.
- (IVSLocalStageStreamLayer *)default270;

/// A preset appropriate for 360p layer.
- (IVSLocalStageStreamLayer *)default360;

/// A preset appropriate for 480p layer.
- (IVSLocalStageStreamLayer *)default480;

/// A preset appropriate for 540p layer.
- (IVSLocalStageStreamLayer *)default540;

/// A preset appropriate for 720p layer.
- (IVSLocalStageStreamLayer *)default720;
@end

/// A collection of predefined configurations and input device sets.
IVS_EXPORT
@interface IVSStagePresets : NSObject

IVS_INIT_UNAVAILABLE

/// Preset broadcast configurations.
+ (IVSSimulcastLocalLayerPresets *)simulcastLocalLayer;

@end

NS_ASSUME_NONNULL_END
